﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="BiomonitoringCases.aspx.cs" Inherits="BiomonitoringCases" %>
 <%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">

    <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" 
        DataSourceID="ObjectDataSource1" DataKeyNames="WKF_CASE_ID" Width="100%" 
        AllowPaging="True" PageSize="20">
        <Columns>
            <asp:HyperLinkField DataNavigateUrlFields="WKF_CASE_ID" 
                DataNavigateUrlFormatString="~/BiomonitoringCase.aspx?caseId={0}" 
                Text="Select" />
            <asp:TemplateField HeaderText="Patient Name">
                <EditItemTemplate>
                    <asp:TextBox ID="TextBox1" runat="server" 
                        Text='<%#AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem, "PATIENT.FullName"))) %>'></asp:TextBox>
                </EditItemTemplate>
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="Label1" runat="server" 
                        Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem, "PATIENT.FullName"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="REFERRAL_ID" HeaderText="Referral Id" 
                SortExpression="REFERRAL_ID" />
            <asp:TemplateField HeaderText="Case Status">
                <EditItemTemplate>
                    <asp:TextBox ID="TextBox2" runat="server" 
                        Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem,"STD_WKFCASEST.DESCRIPTION_TEXT"))) %>'></asp:TextBox>
                </EditItemTemplate>
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID="Label2" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem, "STD_WKFCASEST.DESCRIPTION_TEXT"))) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="UPDATED" DataFormatString="{0:dd/MM/yyyy}" HeaderText="Last Updated" />
            
        </Columns>
    </asp:GridView>

    <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" 
        SelectMethod="GetWorkFlowCases" 
        TypeName="VeteransAffairs.Registries.BusinessManager.BiomonitoringManager" 
        OldValuesParameterFormatString="original_{0}" 
        onselecting="ObjectDataSource1_Selecting">
        <SelectParameters>
            <asp:Parameter DefaultValue="" Name="type" Type="Object" />
        </SelectParameters>
    </asp:ObjectDataSource>

</asp:Content>

